/*
 * Decompiled with CFR 0.152.
 */
package ru.bclib.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.SemanticVersion;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.VersionParsingException;
import net.fabricmc.loader.api.metadata.ContactInformation;
import net.fabricmc.loader.api.metadata.CustomValue;
import net.fabricmc.loader.api.metadata.ModDependency;
import net.fabricmc.loader.api.metadata.ModEnvironment;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.fabricmc.loader.api.metadata.Person;
import net.fabricmc.loader.util.version.SemanticVersionImpl;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bclib.BCLib;
import ru.bclib.util.PathUtil;

public class ModUtil {
    private static Map<String, ModInfo> mods;

    public static void invalidateCachedMods() {
        mods = null;
    }

    public static Map<String, ModInfo> getMods() {
        if (mods != null) {
            return mods;
        }
        mods = new HashMap<String, ModInfo>();
        Logger logger = LogManager.getFormatterLogger((String)"BCLib|ModLoader");
        PathUtil.fileWalker(PathUtil.MOD_FOLDER.toFile(), false, ModUtil::accept);
        return mods;
    }

    private static ModMetadata readJSON(InputStream is, String sourceFile) throws IOException {
        JsonReader reader = new JsonReader((Reader)new InputStreamReader(is, StandardCharsets.UTF_8));
        try {
            SemanticVersionImpl ver;
            JsonObject data = new JsonParser().parse(reader).getAsJsonObject();
            try {
                ver = new SemanticVersionImpl(data.get("version").getAsString(), false);
            }
            catch (VersionParsingException e) {
                BCLib.LOGGER.error("Unable to parse Version in " + sourceFile);
                ModMetadata modMetadata = null;
                reader.close();
                return modMetadata;
            }
            if (data.get("id") == null) {
                BCLib.LOGGER.error("Unable to read ID in " + sourceFile);
                ModMetadata modMetadata = null;
                return modMetadata;
            }
            if (data.get("name") == null) {
                BCLib.LOGGER.error("Unable to read name in " + sourceFile);
                ModMetadata modMetadata = null;
                return modMetadata;
            }
            ModMetadata modMetadata = new ModMetadata(){
                final /* synthetic */ Version val$ver;
                final /* synthetic */ JsonObject val$data;
                final /* synthetic */ String val$sourceFile;
                {
                    this.val$ver = version;
                    this.val$data = jsonObject;
                    this.val$sourceFile = string;
                }

                public Version getVersion() {
                    return this.val$ver;
                }

                public String getType() {
                    return "fabric";
                }

                public String getId() {
                    return this.val$data.get("id").getAsString();
                }

                public Collection<String> getProvides() {
                    return new ArrayList<String>();
                }

                public ModEnvironment getEnvironment() {
                    String environment;
                    JsonElement env = this.val$data.get("environment");
                    if (env == null) {
                        BCLib.LOGGER.warning("No environment specified in " + this.val$sourceFile, new Object[0]);
                    }
                    String string = environment = env == null ? "" : env.getAsString().toLowerCase(Locale.ROOT);
                    if (environment.isEmpty() || environment.equals("*") || environment.equals("\"*\"") || environment.equals("common")) {
                        JsonElement entrypoints = this.val$data.get("entrypoints");
                        boolean hasClient = true;
                        if (entrypoints != null && entrypoints.isJsonObject()) {
                            JsonElement client = entrypoints.getAsJsonObject().get("client");
                            if (client != null && client.isJsonArray()) {
                                hasClient = client.getAsJsonArray().size() > 0;
                            } else if (client == null || !client.isJsonPrimitive()) {
                                hasClient = false;
                            } else if (!client.getAsJsonPrimitive().isString()) {
                                hasClient = false;
                            }
                        }
                        return ModEnvironment.UNIVERSAL;
                    }
                    if (environment.equals("client")) {
                        return ModEnvironment.CLIENT;
                    }
                    if (environment.equals("server")) {
                        return ModEnvironment.SERVER;
                    }
                    BCLib.LOGGER.error("Unable to read environment in " + this.val$sourceFile);
                    return ModEnvironment.UNIVERSAL;
                }

                public Collection<ModDependency> getDepends() {
                    return new ArrayList<ModDependency>();
                }

                public Collection<ModDependency> getRecommends() {
                    return new ArrayList<ModDependency>();
                }

                public Collection<ModDependency> getSuggests() {
                    return new ArrayList<ModDependency>();
                }

                public Collection<ModDependency> getConflicts() {
                    return new ArrayList<ModDependency>();
                }

                public Collection<ModDependency> getBreaks() {
                    return new ArrayList<ModDependency>();
                }

                public Collection<ModDependency> getDependencies() {
                    return new ArrayList<ModDependency>();
                }

                public String getName() {
                    return this.val$data.get("name").getAsString();
                }

                public String getDescription() {
                    return "";
                }

                public Collection<Person> getAuthors() {
                    return new ArrayList<Person>();
                }

                public Collection<Person> getContributors() {
                    return new ArrayList<Person>();
                }

                public ContactInformation getContact() {
                    return null;
                }

                public Collection<String> getLicense() {
                    return new ArrayList<String>();
                }

                public Optional<String> getIconPath(int size) {
                    return Optional.empty();
                }

                public boolean containsCustomValue(String key) {
                    return false;
                }

                public CustomValue getCustomValue(String key) {
                    return null;
                }

                public Map<String, CustomValue> getCustomValues() {
                    return new HashMap<String, CustomValue>();
                }

                public boolean containsCustomElement(String key) {
                    return false;
                }

                public JsonElement getCustomElement(String key) {
                    return null;
                }
            };
            return modMetadata;
        }
        finally {
            try {
                reader.close();
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                throwable2.addSuppressed(throwable);
            }
        }
    }

    public static ModInfo getModInfo(String modID) {
        return ModUtil.getModInfo(modID, true);
    }

    public static ModInfo getModInfo(String modID, boolean matchVersion) {
        ModUtil.getMods();
        ModInfo mi = mods.get(modID);
        if (mi == null || matchVersion && !ModUtil.getModVersion(modID).equals(mi.getVersion())) {
            return null;
        }
        return mi;
    }

    public static String getModVersion(String modID) {
        Optional optional = FabricLoader.getInstance().getModContainer(modID);
        if (optional.isPresent()) {
            ModContainer modContainer = (ModContainer)optional.get();
            return ModInfo.versionToString(modContainer.getMetadata().getVersion());
        }
        return ModUtil.getModVersionFromJar(modID);
    }

    public static String getModVersionFromJar(String modID) {
        ModInfo mi = ModUtil.getModInfo(modID, false);
        if (mi != null) {
            return mi.getVersion();
        }
        return "0.0.0";
    }

    public static int convertModVersion(String version) {
        if (version.isEmpty()) {
            return 0;
        }
        try {
            int res = 0;
            String semanticVersionPattern = "(\\d+)\\.(\\d+)(\\.(\\d+))?\\D*";
            Matcher matcher = Pattern.compile("(\\d+)\\.(\\d+)(\\.(\\d+))?\\D*").matcher(version);
            if (matcher.find()) {
                if (matcher.groupCount() > 0) {
                    int n = res = matcher.group(1) == null ? 0 : (Integer.parseInt(matcher.group(1)) & 0xFF) << 22;
                }
                if (matcher.groupCount() > 1) {
                    res |= matcher.group(2) == null ? 0 : (Integer.parseInt(matcher.group(2)) & 0xFF) << 14;
                }
                if (matcher.groupCount() > 3) {
                    res |= matcher.group(4) == null ? 0 : Integer.parseInt(matcher.group(4)) & 0x3FFF;
                }
            }
            return res;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static String convertModVersion(int version) {
        int a = version >> 22 & 0xFF;
        int b = version >> 14 & 0xFF;
        int c = version & 0x3FFF;
        return String.format(Locale.ROOT, "%d.%d.%d", a, b, c);
    }

    public static boolean isLargerVersion(String v1, String v2) {
        return ModUtil.convertModVersion(v1) > ModUtil.convertModVersion(v2);
    }

    public static boolean isLargerOrEqualVersion(String v1, String v2) {
        return ModUtil.convertModVersion(v1) >= ModUtil.convertModVersion(v2);
    }

    private static void accept(Path file) {
        block13: {
            try {
                FileSystem fs;
                URI uri = URI.create("jar:" + file.toUri());
                try {
                    fs = FileSystems.getFileSystem(uri);
                }
                catch (Exception e) {
                    fs = FileSystems.newFileSystem(file);
                }
                if (fs == null) break block13;
                try {
                    Path modMetaFile = fs.getPath("fabric.mod.json", new String[0]);
                    if (modMetaFile == null) break block13;
                    try (InputStream is = Files.newInputStream(modMetaFile, new OpenOption[0]);){
                        ModMetadata mc = ModUtil.readJSON(is, uri.toString());
                        if (mc != null) {
                            mods.put(mc.getId(), new ModInfo(mc, file));
                        }
                    }
                }
                catch (Exception e) {
                    BCLib.LOGGER.error("Error for " + uri + ": " + e.toString());
                }
            }
            catch (Exception e) {
                BCLib.LOGGER.error("Error for " + file.toUri() + ": " + e.toString());
                e.printStackTrace();
            }
        }
    }

    public static class ModInfo {
        public final ModMetadata metadata;
        public final Path jarPath;

        ModInfo(ModMetadata metadata, Path jarPath) {
            this.metadata = metadata;
            this.jarPath = jarPath;
        }

        public static String versionToString(Version v) {
            if (v instanceof SemanticVersion) {
                return ModInfo.versionToString((SemanticVersion)v);
            }
            return ModUtil.convertModVersion(ModUtil.convertModVersion(v.toString()));
        }

        public static String versionToString(SemanticVersion v) {
            StringBuilder stringBuilder = new StringBuilder();
            boolean first = true;
            int cCount = Math.min(v.getVersionComponentCount(), 3);
            for (int i = 0; i < cCount; ++i) {
                if (first) {
                    first = false;
                } else {
                    stringBuilder.append('.');
                }
                stringBuilder.append(v.getVersionComponent(i));
            }
            return stringBuilder.toString();
        }

        public String toString() {
            return "ModInfo{id=" + this.metadata.getId() + ", version=" + this.metadata.getVersion() + ", jarPath=" + this.jarPath + "}";
        }

        public String getVersion() {
            if (this.metadata == null) {
                return "0.0.0";
            }
            return ModInfo.versionToString(this.metadata.getVersion());
        }
    }
}

